#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include "callbacks.h"
#include "interface.h"
#include "support.h"

#define PORTNAMELEN 10

speed_t GetBaudRate( GString rate);
gint BeforeWrite(void);
gint BeforeRead(void);
gint BeforeWriteRead(void);


extern Trans DTransfer;

//---------------------------------------------------------//
/*
	Check parameters before Do Write function.
	Check:
			baudrate -- default 9600
			filename -- -1 no filename
			usbline	 -- -2 no usbline
			ttyline  -- -3 no ttyline

	return 0 as no problem
*/
gint BeforeWrite(void)
{
	if ( NULL == DTransfer.filename )
		return (-1);
	
	if ( NULL == DTransfer.usbline )
		return (-2);
	
	if ( NULL == DTransfer.ttyline)
		return (-3);
	
}

//---------------------------------------------------------//
/*
	Check parameters before Do Write function.
	Check:
			baudrate -- default 9600
			filename -- -1 no filename
			usbline	 -- -2 no usbline
			ttyline  -- -3 no ttyline

	return 0 as no problem
*/
gint BeforeRead(void)
{
	if ( NULL == DTransfer.filename)
		return (-1);
	if ( NULL == DTransfer.usbline)
		return (-2);
	if ( NULL == DTransfer.ttyline)
		return (-3);
	
}

//---------------------------------------------------------//
/*
	Check parameters before Do Write function.
	Check:
			baudrate -- default 9600
			filename -- -1 no filename
			filename2 -- -2 no filename2
			usbline	 -- -3 no usbline
			ttyline  -- -4 no ttyline

	return 0 as no problem
*/
gint BeforeWriteRead(void)
{
	
	
}

//---------------------------------------------------------//

void
on_btn_Write_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
	gboolean ok_before_write;
	
	
	
	
}

//---------------------------------------------------------//
void
on_bnt_Read_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
	MessageBox("read");
}

//---------------------------------------------------------//

void
on_window1_destroy                     (GtkObject       *object,
                                        gpointer         user_data)
{
	gtk_main_quit();
}
//---------------------------------------------------------//

void
on_btn_WriteRead_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{

}

//---------------------------------------------------------//
void
on_chk_LoopBack_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}

//---------------------------------------------------------//
void
on_combobox1_changed                   (GtkComboBox     *combobox,
                                        gpointer         user_data)
{
	
	GString rate;
	
	rate.str = gtk_combo_box_get_active_text  (combobox);
	DTransfer.baudrate = GetBaudRate(rate);
	
}

//---------------------------------------------------------//

void
on_cbo_UsbTty_changed   (GtkComboBox     *combobox,
							gpointer         user_data)
{
	GString portstr;
		
	portstr.str = gtk_combo_box_get_active_text  (combobox);
	g_strlcpy(DTransfer.usbline, portstr.str, PORTNAMELEN);
	
}

//---------------------------------------------------------//
void
on_cbo_Tty_changed  (GtkComboBox     *combobox,
					 gpointer         user_data)
{
	GString portstr;
	
	portstr.str = gtk_combo_box_get_active_text  (combobox);
	g_strlcpy(DTransfer.ttyline, portstr.str, PORTNAMELEN);
	
		
}

//---------------------------------------------------------//

void
on_btn_WriteFileOpen_file_set          (GtkFileChooserButton *filechooserbutton,
                                        gpointer         user_data)
{
	GtkWidget *entry1 = (GtkWidget*) user_data;
	gchar *filename2 = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER(filechooserbutton));
	gtk_entry_set_text( GTK_ENTRY(entry1), filename2);
	
	

}

//---------------------------------------------------------//
void
on_btn_ReadFileOpen_file_set           (GtkFileChooserButton *filechooserbutton,
                                        gpointer         user_data)
{
	GtkWidget *entry1 = (GtkWidget*) user_data;
	gchar *filename2 = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER(filechooserbutton));
	gtk_entry_set_text( GTK_ENTRY(entry1), filename2);
	
}

//---------------------------------------------------------//
void
on_btn_WriteRead_ReadOpen_file_set     (GtkFileChooserButton *filechooserbutton,
                                        gpointer         user_data)
{
	GtkWidget *entry1 = (GtkWidget*) user_data;
	gchar *filename2 = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER(filechooserbutton));
	gtk_entry_set_text( GTK_ENTRY(entry1), filename2);
	
}

//---------------------------------------------------------//
void
on_btn_WriteRead_WriteOpen_file_set    (GtkFileChooserButton *filechooserbutton,
                                        gpointer         user_data)
{
	GtkWidget *entry1 = (GtkWidget*) user_data;
	gchar *filename2 = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER(filechooserbutton));
	gtk_entry_set_text( GTK_ENTRY(entry1), filename2);
	
}


	
//---------------------------------------------------------//

void on_btn_WriteOpen_clicked (GtkButton       *button,
								gpointer         win)
{
	GtkWidget *dialog;
	GtkWidget *entry;

	entry = lookup_widget( GTK_WIDGET(button), "txt_FileName");
	
	dialog = gtk_file_chooser_dialog_new ("Open File",
										  (GtkWindow *)win,
										  GTK_FILE_CHOOSER_ACTION_OPEN,
										  GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
										  GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
										  NULL);

	if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
	{
		char *filename;

		filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
		gtk_entry_set_text( GTK_ENTRY(entry), filename);
		
		//open_file (filename);
		g_free (filename);
		
	}

	gtk_widget_destroy (dialog);
}

//---------------------------------------------------------//
void on_btn_WriteRead_ReadOpen_clicked(GtkButton       *button,
										gpointer         win)
{
	GtkWidget *dialog;
	GtkWidget *entry;

	entry = lookup_widget( GTK_WIDGET(button), 
						   "txt_WriteRead_Read");
	
	dialog = gtk_file_chooser_dialog_new ("Open File",
										(GtkWindow *)win,
										GTK_FILE_CHOOSER_ACTION_OPEN,
										GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
										GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
										NULL);

	if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
	{
		char *filename;

		filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
		gtk_entry_set_text( GTK_ENTRY(entry), filename);
		
		//open_file (filename);
		g_free (filename);
		
	}

	gtk_widget_destroy (dialog);
}

//---------------------------------------------------------//
void on_btn_WriteRead_WriteOpen_clicked(GtkButton       *button,
										gpointer         win)
{
	GtkWidget *dialog;
	GtkWidget *entry;

	entry = lookup_widget( GTK_WIDGET(button), "txt_WriteRead_Write");
	
	dialog = gtk_file_chooser_dialog_new ("Open File",
										(GtkWindow *)win,
										GTK_FILE_CHOOSER_ACTION_OPEN,
										GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
										GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
										NULL);

	if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
	{
		char *filename;

		filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
		gtk_entry_set_text( GTK_ENTRY(entry), filename);
		
		//open_file (filename);
		g_free (filename);
		
	}

	gtk_widget_destroy (dialog);
}

//---------------------------------------------------------//
void on_btn_ReadOpen_clicked(GtkButton       *button,
							 gpointer         win)
{
	GtkWidget *dialog;
	GtkWidget *entry;

	entry = lookup_widget( GTK_WIDGET(button), "txt_ReadFile");
	
	dialog = gtk_file_chooser_dialog_new ("Open File",
										(GtkWindow *)win,
										GTK_FILE_CHOOSER_ACTION_OPEN,
										GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
										GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
										NULL);

	if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
	{
		char *filename;

		filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
		gtk_entry_set_text( GTK_ENTRY(entry), filename);
		
		//open_file (filename);
		g_free (filename);
		
	}

	gtk_widget_destroy (dialog);
}

//---------------------------------------------------------//
speed_t GetBaudRate( GString rate)
{
	if ( 0 == g_strcasecmp( rate.str, "1200"))
		return 1200;
	
	if ( 0 == g_strcasecmp( rate.str, "2400"))
		return 2400;
	
	if ( 0 == g_strcasecmp( rate.str, "4800"))
		return 4800;
	
	if ( 0 == g_strcasecmp( rate.str, "9600"))
		return 9600;
	
	if ( 0 == g_strcasecmp( rate.str, "38400"))
		return 38400;
	
	if ( 0 == g_strcasecmp( rate.str, "57600"))
		return 57600;
	
	if ( 0 == g_strcasecmp( rate.str, "115200"))
		return 115200;
	
	
	
}

//---------------------------------------------------------//
gboolean
on_notebook1_change_current_page       (GtkNotebook     *notebook,
                                        gint             offset,
                                        gpointer         user_data)
{
	gchar out[256];
	
	g_sprintf(out, "now is at page %d", offset);
	MessageBox(out);
		
  return FALSE;
}

